/*
 *  Copyright (C) 2002-2003  The DOSBox Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mt32emu.h"
#include "mixer.h"

MT32Emu::Synth *_usesynth;
MixerChannel *mt32chan;

static void MT32_CallBack(Bitu len) {
   _usesynth->render((Bit16s *)MixTemp, len);
   mt32chan->AddSamples_s16(len,(Bit16s *)MixTemp);
}

static int report(void *userData, MT32Emu::ReportType type, const void *reportData) {
   switch(type) {
   case MT32Emu::ReportType_errorControlROM:
      LOG(LOG_ALL,LOG_ERROR)("MT32:Couldn't find control files");
      break;
   case MT32Emu::ReportType_errorPCMROM:
      LOG(LOG_ALL,LOG_ERROR)("MT32:Couldn't open MT32_PCM.ROM file");
      break;
   default:
      //LOG(LOG_ALL,LOG_NORMAL)("MT32: Report %d",type);
      break;
   }
   return 0;
}

int mt32samplerate;

class MidiHandler_mt32: public MidiHandler {
private:
   MT32Emu::Synth *_synth;
   int _outputRate;
   bool isOpen;

public:
   MidiHandler_mt32() : isOpen(false),MidiHandler() {};
   char * GetName(void) { return "mt32";};
   bool Open(const char * conf) {
      MT32Emu::SynthProperties tmpProp;
      memset(&tmpProp, 0, sizeof(tmpProp));
      tmpProp.sampleRate = mt32samplerate;
      LOG_MSG("MT32:Set sample rate to %d", mt32samplerate);
      tmpProp.useDefaultReverb = true;
      tmpProp.useReverb = true;
      tmpProp.reverbType = 1;
      tmpProp.reverbTime = 5;
      tmpProp.reverbLevel = 3;
      //tmpProp.printDebug = &vdebug;
      tmpProp.report = &report;
      _synth = new MT32Emu::Synth();
      if (_synth->open(tmpProp)==0) {
         LOG(LOG_ALL,LOG_ERROR)("MT32:Error initialising emulation");
         return false;
      }
      _usesynth=_synth;

      mt32chan=MIXER_AddChannel(MT32_CallBack,tmpProp.sampleRate,"MT32");
      mt32chan->Enable(false);
      return true;
   };
   void Close(void) {
      if (!isOpen) return;
      _synth->close();
      delete _synth;
      _synth = NULL;
      isOpen=false;
   };
   void PlayMsg(Bit8u * msg) {
      mt32chan->Enable(true);
      _synth->playMsg(*((Bit32u*) msg));
   };
   void PlaySysex(Bit8u * sysex,Bitu len) {
#ifdef MT32DEBUG
      LOG_MSG("sysex");
#endif
      if (sysex[0] == 0xf0) {
         _synth->playSysex(sysex, len);
      } else {
         _synth->playSysexWithoutFraming(sysex, len);
      }
   };
};

MidiHandler_mt32 Midi_mt32;
