/*
 *  Direct3D rendering code by gulikoza
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DIRECT3D_H_
#define __DIRECT3D_H_

#include <d3d9.h>

//#define D3DDEBUG		// Uncomment this if you want d3d messages

#define SAFE_RELEASE(p)		{ if(p) { (p)->Release(); (p)=NULL; } }

#if defined (_MSC_VER)						/* MS Visual C++ */
#define	strcasecmp(a,b) stricmp(a,b)
#endif

// Vertex format
#define D3DFVF_TLVERTEX D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1

#if C_D3DSHADERS
#include "scalingeffect.h"
#else
#define D3DXMATRIX D3DMATRIX
#define D3DXVECTOR3 vec3f
#define D3DXVECTOR2 vec2f
#define D3DXMatrixOrthoOffCenterLH MatrixOrthoOffCenterLH
#define D3DXMatrixTranslation MatrixTranslation
#define D3DXMatrixScaling MatrixScaling

struct vec3f {
    float x, y, z;
    vec3f() { }
    vec3f(float vx, float vy, float vz)
    : x(vx), y(vy), z(vz) { }
};

struct vec2f {
    float x, y;
    vec2f() { }
    vec2f(float vx, float vy)
    : x(vx), y(vy) { }
};

#endif

class CDirect3D {
private:

    // globals
    HMODULE			mhmodDX9;
    IDirect3D9*			pD3D9;
    IDirect3DDevice9*		pD3DDevice9;

    D3DPRESENT_PARAMETERS 	d3dpp;			// Present parameters

    DWORD dwWidth, dwHeight;                            // DOSBox framebuffer size
    DWORD dwScaledWidth, dwScaledHeight;                // D3D backbuffer size

    // display modes
    D3DDISPLAYMODE		*modes;
    unsigned int		iMode;
    DWORD			dwNumModes;

    // vertex stuff
    IDirect3DVertexBuffer9*	vertexBuffer;		// VertexBuffer

    // Custom vertex
    struct TLVERTEX {
	D3DXVECTOR3 position;       // vertex position
	D3DCOLOR    diffuse;
        D3DXVECTOR2 texcoord;       // texture coords
    };

    // Projection matrices
    D3DXMATRIX			m_matProj;
    D3DXMATRIX			m_matWorld;
    D3DXMATRIX			m_matView;

#if C_D3DSHADERS
    D3DXMATRIX			m_matPreProj;
    D3DXMATRIX			m_matPreView;
    D3DXMATRIX			m_matPreWorld;

    // Pixel shader
    char			pshader[30];
    ScalingEffect 		*psEffect;
#endif
    LPDIRECT3DTEXTURE9		lpWorkTexture;
    bool 			psEnabled;
    bool			preProcess;

    // function declarations
    HRESULT InitD3D(HWND, Bitu, Bitu, bool);

    HRESULT RestoreDeviceObjects(void);
    HRESULT InvalidateDeviceObjects(void);
    HRESULT CreateDisplayTexture(void);
    HRESULT CreateVertex(void);
#if !(C_D3DSHADERS)
    D3DXMATRIX* MatrixOrthoOffCenterLH(D3DXMATRIX*, float, float, float, float, float, float);
    D3DXMATRIX* MatrixScaling(D3DXMATRIX*, float, float, float);
    D3DXMATRIX* MatrixTranslation(D3DXMATRIX*, float, float, float);
#endif

    void SetupSceneScaled(void);
    void DestroyD3D(void);

public:

    // texture stuff
    LPDIRECT3DTEXTURE9		lpTexture;		// D3D texture
    DWORD			dwTexHeight, dwTexWidth;

    bool square, pow2, dynamic, bpp16;			// Texture limitations
    Bit8u aspect;

    // Pixel shader status
    bool psActive;

    // function declarations
    HRESULT InitializeDX(HWND, Bitu, Bitu, bool);
    HRESULT LoadPixelShader(const char*, double, double);
    HRESULT Resize3DEnvironment(Bitu, Bitu, Bitu, Bitu, bool fullscreen=false);

    bool D3DSwapBuffers(void);

    CDirect3D() {
	mhmodDX9 = NULL;
	pD3D9 = NULL;
	pD3DDevice9 = NULL;
	modes = NULL;
	vertexBuffer = NULL;

	bpp16 = false;
	aspect = 0;
	lpTexture = NULL;
	lpWorkTexture = NULL;

	psEnabled = false;
	psActive = false;
	preProcess = false;
#if C_D3DSHADERS
	strcpy(pshader, "shaders\\");
	psEffect = NULL;
#endif
    }

    ~CDirect3D() {
#ifdef D3DDEBUG
	LOG_MSG("D3D:Shutting down Direct3D");
#endif
	DestroyD3D();
    }

};

#endif // __DIRECT3D_H_
